---
name: intro-email-generator
description: Crafts compelling, forwardable introduction emails for intro requests. Use when user needs help writing an email asking a mutual connection to introduce them to someone at a company that's hiring. The skill produces emails that can be forwarded without editing.
license: MIT
metadata:
  version: "1.2.1"
---

# Intro Email Generator

## How Intro Requests Work

This skill helps with a specific scenario involving three people:

1. **The Job Seeker** — Looking for an opportunity at a target company
2. **The Forwarder** — Knows both the job seeker AND someone at the target company
3. **The Target Contact** — Works at the company that's hiring

**The flow:**
1. Job Seeker writes email addressed to The Forwarder
2. The Forwarder receives it, adds a quick note ("Hey, worth a look!"), and forwards to The Target Contact
3. The Target Contact sees a well-crafted pitch they can act on

**CRITICAL: The email is addressed to The Forwarder, NOT The Target Contact.** The magic is that it reads well when forwarded — The Forwarder doesn't need to rewrite anything.

## Common Mistake

People often write the email addressed to the wrong person. They write to the target contact instead of the forwarder.

**Wrong:** "Hi Sarah, I saw that Acme Corp is hiring and I'd love to chat about the PM role..."
(This is written to the target contact — the forwarder can't just forward this)

**Right:** "Hey Mike, I'm interested in the PM role at Acme Corp. Would you be open to connecting me with Sarah?"
(This is written to the forwarder — they can forward it directly to Sarah)

## Required Inputs

Gather before generating:
- **Resume** — uploaded file, pasted text, or URL
- **Job description** — text or job posting URL
- **Additional context** (optional) — key achievements, why they're interested, specific angles to emphasize
- **Job URL** (optional) — for the closing; if unavailable, reference job title instead

## Email Structure

```
Subject: Quick intro request - [Company] [Role]

Hey [Forwarder's first name],

[Opening: 2-3 sentences connecting a verified achievement to the company's specific challenge. Show understanding of what the company does.]

Quick background:
• [HIGH PRIORITY: Most relevant achievement with metric + context]
• [MEDIUM PRIORITY: Supporting achievement with metric + context]
• [Additional evidence: Leadership, scale, or relevant experience]

[Interest statement: Connect strongest achievement to company's specific needs]

Would you be open to connecting me with someone on the [Team] team? I'm interested in this role: [job URL]

Best,
[Job Seeker's name]
```

## Analysis Approach

1. **Extract company context** from job description: stage, core problems, team structure, success metrics
2. **Map candidate experience** to job requirements: find overlaps, note gaps, identify unique value
3. **Verify claims** against resume: only use achievements that have evidence
4. **Select style**:
   - DATA-DRIVEN: When context emphasizes metrics, growth, analytics ("achieved 250% growth...")
   - ACTION-DRIVEN: When context emphasizes building, launching, leadership ("after launching from 0-to-1...")

See [reference.md](reference.md) for detailed analysis framework.

## Quality Standards

- Every metric must be verified against resume
- Use company/product names, never "you" or "your" (bad: "your platform" → good: "the Amplitude platform")
- Bullets use "• " format, max 12 words each
- Total body under 150 words
- Include job URL in closing (or job title if URL unavailable)
- Tone: professional but conversational, not templated

## Example

**Request:** "I want to ask my friend Mike to intro me to someone at AnalyticsCo for their PM role."

**Generated Email:**
```
Subject: Quick intro request - AnalyticsCo Product Manager

Hey Mike,

Having achieved 250% WAU growth in our analytics product, I appreciate the scale of AnalyticsCo's platform challenges. My experience optimizing retention metrics showed me how critical accurate data is to product decisions, and I see direct parallels with how AnalyticsCo helps companies turn data into insights.

Quick background:
• Led analytics product growth from 10K to 35K WAU over 18 months
• Redesigned retention tracking, improving engagement 40% YoY
• Managed 4-person team through Series B product overhaul

Based on my experience scaling analytics products, I see valuable opportunities to help AnalyticsCo expand their enterprise offering.

Would you be open to connecting me with someone on the Product team? I'm interested in this role: https://analyticsCo.com/jobs/pm

Best,
Alex
```

Mike can now forward this directly to his contact at AnalyticsCo.

For more examples, see [examples.md](examples.md).

## Related Skills

**network-jobs** - Search job openings at companies where you have connections through your network. Use this skill first to find opportunities, then use intro-email-generator to craft the outreach email.

## Integration with network-jobs

If the user found a job using the network-jobs skill:
- The job URL is already available from the search results
- The company and role context can be pulled from the job data
- Ask for the user's resume and the name of their connection (the forwarder)
- Generate the intro email using the job details
